// Version/Precision tags are added programmatically on shader load

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;
attribute vec2 vaUV;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mModel;
uniform vec3 uLightPos;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position
varying vec2 UV; // UV

void main()
{
  C = vaColor;
  L = normalize(mat3(mView) * uLightPos);
  N = normalize(mat3(mView) * mat3(mModel) * vaNormal);
  P = vec3(mModel * vec4(vPosition, 1.0));
  UV = vaUV;

  gl_Position = mProj * mView * mModel * vec4(vPosition, 1.0);
}
